from simpleimage import SimpleImage     # images library
import sys


def grayscale(filename):
    image = SimpleImage(filename)
    for y in range(image.height):
        for x in range(image.width):
            pixel = image.get_pixel(x, y)
            # get the average
            pixel_sum = pixel.red + pixel.green + pixel.blue
            avg = pixel_sum/3
            # set each pixel to the average
            pixel.red = avg
            pixel.green = avg
            pixel.blue = avg
    return image


# sample main program
def main():
    args = sys.argv[1:]
    filename = args[0]
    grayed_image = grayscale(filename)
    grayed_image.show()  # this function displays the image!


if __name__ == '__main__':
    main()